def affected_positions(i, j, n):
    s = set()
    for x in [i - 1, i, j - 1, j]:
        if 0 <= x < n - 1:
            s.add(x)
    return s

def main():
    import sys
    input = sys.stdin.read
    data = input().split()

    n = int(data[0])
    q = int(data[1])
    p = list(map(int, data[2:2 + n]))

    queries = []
    idx = 2 + n
    for _ in range(q):
        i = int(data[idx]) - 1
        j = int(data[idx + 1]) - 1
        queries.append((i, j))
        idx += 2

    bad = set()
    for i in range(n - 1):
        if p[i] > p[i + 1]:
            bad.add(i)

    print(len(bad))

    for i, j in queries:
        for x in affected_positions(i, j, n):
            if p[x] > p[x + 1]:
                bad.discard(x)
        p[i], p[j] = p[j], p[i]
        for x in affected_positions(i, j, n):
            if p[x] > p[x + 1]:
                bad.add(x)
        print(len(bad))

if __name__ == "__main__":
    main()